import torch

original_tensor = torch.randn(2, 2, 3)

expanded_tensor_1 = original_tensor.unsqueeze(0).expand(3, 2, 2, 3)

expanded_tensor_2 = original_tensor.unsqueeze(-1).expand(2, 2, 3, 3)

scaled_tensor_1 = expanded_tensor_1 * 0.1
scaled_tensor_2 = expanded_tensor_2 * 0.1

sum_tensor_1 = torch.sum(scaled_tensor_1, dim=0)

sum_tensor_2 = torch.sum(scaled_tensor_2, dim=-1)


print("Sum Tensor 1 shape (after summing over first dimension):", sum_tensor_1.shape)
print("Sum Tensor 2 shape (after summing over last dimension):", sum_tensor_2.shape)

print("Sum Tensor 1:", sum_tensor_1)
print("Sum Tensor 2:", sum_tensor_2)
